-- change directory to program location
parse source  . . pgm
call directory filespec('L', pgm) 

-- create a new document and add a blank page
doc=.bsf~new("org.apache.pdfbox.pdmodel.PDDocument")
page=.bsf~new("org.apache.pdfbox.pdmodel.PDPage")
doc~addPage(page)

-- define font type
fontclass = "org.apache.pdfbox.pdmodel.font.Standard14Fonts"
fname = BSF.loadClass(fontclass)~FontName~HELVETICA_BOLD
font=.bsf~new("org.apache.pdfbox.pdmodel.font.PDType1Font",fname)

-- create a content stream
contclass = "org.apache.pdfbox.pdmodel.PDPageContentStream"
cont=.bsf~new(contclass,doc,page)
cont~setLineWidth(1)
cont~setFont(font, 18)

-- define the cell and table
initx=50
inity=700
cheight=30
cwidth=100
col=5
row= 10

-- start the loops to draw the table and insert contents
do i=0 to row-1
do j=0 to col-1
cont~addRect(initx+j*cwidth,inity-i*cheight,cwidth,-cheight)
cont~beginText
cont~newLineAtOffset(initx+j*cwidth+10,inity-i*cheight-cheight+10)
cont~showText("Cell" "(" || j+1 || "," || i+1 || ")")
cont~endText
end
end

-- make the table visible
cont~stroke
cont~close

-- save and close the document file
doc~save("06-table with content.pdf")
doc~close


-- get java support
::requires "BSF.CLS"